/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitMessageSourceServices;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSource;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSourceFactory;
import com.syntevo.openapi.deprecated.smartsvn.file.Path;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.openapi.deprecated.util.Assert;
import com.syntevo.plugin.common.bugtracker.commit.messagesource.BugtrackerCommitMessageSourceUtils;
import com.syntevo.plugin.trac.commit.TracUrl;
import com.syntevo.plugin.trac.commit.messagesource.TracCommitMessageSource;
import org.jetbrains.annotations.Nullable;

public final class TracCommitMessageSourceFactory
implements ICommitMessageSourceFactory {
    private final SettingsServices settingsServices;
    private final GuiSpacings spacings;

    public TracCommitMessageSourceFactory(SettingsServices settingsServices, GuiSpacings spacings) {
        this.settingsServices = settingsServices;
        this.spacings = spacings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICommitMessageSource createCommitMessageSource(@Nullable CommitMessageSourceServices sourceServices) {
        sourceServices = (CommitMessageSourceServices)Assert.assertNotNull((Object)sourceServices);
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            Path commitRootPath = sourceServices.getCommitRootPath();
            String bugtraqURL = BugtrackerCommitMessageSourceUtils.findBugtraqURL(sourceServices.getClients(), commitRootPath);
            if (bugtraqURL == null) {
                ICommitMessageSource iCommitMessageSource = null;
                return iCommitMessageSource;
            }
            TracUrl url = TracUrl.parseFromBugtraqUrls(bugtraqURL);
            if (url == null) {
                ICommitMessageSource iCommitMessageSource = null;
                return iCommitMessageSource;
            }
            TracCommitMessageSource tracCommitMessageSource = new TracCommitMessageSource(url.getBaseUrl(), this.settingsServices, sourceServices.getBugtraqProperties(), this.spacings, sourceServices.getDialogDisplayer());
            return tracCommitMessageSource;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }
}

