/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.plugin.trac.commit.messagesource.TracIssueByRelevanceComparator;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class TracIssueList {
    private final Set<TracIssue> issues = new HashSet<TracIssue>();

    public synchronized void addIssues(@NotNull List<TracIssue> issuesToAdd) {
        this.issues.addAll(issuesToAdd);
    }

    @NotNull
    public synchronized List<TracIssue> getIssuesInOrder(@NotNull List<TracIssueVersion> unreleasedVersions, @NotNull List<TracIssueMilestone> incompleteMilestones) {
        ArrayList<TracIssue> issuesInOrder = new ArrayList<TracIssue>(this.issues);
        Collections.sort(issuesInOrder, new TracIssueByRelevanceComparator(unreleasedVersions, incompleteMilestones));
        return issuesInOrder;
    }

    public synchronized void clear() {
        this.issues.clear();
    }
}

