/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.plugin.trac.TracPlugin;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueList;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueLoaderTableUpdater;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueTable;
import com.syntevo.plugin.trac.commit.messagesource.TracQueryConfiguration;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueStatus;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import com.syntevo.plugin.trac.transport.TracJsonRpcClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracIssueLoader
extends Thread {
    private static final int UNRELEASED_VERSIONS_TO_DISPLAY;
    private static final int INCOMPLETE_MILESTONES_TO_DISPLAY;
    private final TracIssueList issueList = new TracIssueList();
    private final TracIssueTable table;
    private TracQueryConfiguration configuration;
    private boolean forceRefresh;
    private boolean aborted;
    private TracIssueLoaderTableUpdater tableUpdater;

    public TracIssueLoader(@NotNull TracIssueTable table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        TracQueryConfiguration configuration = null;
        while (true) {
            try {
                while (true) {
                    TracIssueLoader tracIssueLoader = this;
                    // MONITORENTER : tracIssueLoader
                    while (this.configuration == null && !this.aborted) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex2) {}
                    }
                    if (this.aborted) {
                        // MONITOREXIT : tracIssueLoader
                        return;
                    }
                    if (TracIssueLoader.areConfigurationsEqual(configuration, this.configuration) && !this.forceRefresh) {
                        // MONITOREXIT : tracIssueLoader
                        continue;
                    }
                    configuration = this.configuration;
                    this.forceRefresh = false;
                    this.issueList.clear();
                    if (configuration == null) {
                        // MONITOREXIT : tracIssueLoader
                        continue;
                    }
                    TracJsonRpcClient queryClient = new TracJsonRpcClient(configuration.getConnection());
                    this.tableUpdater = new TracIssueLoaderTableUpdater(queryClient, this.issueList, this.table);
                    // MONITOREXIT : tracIssueLoader
                    try {
                        try {
                            if (configuration.getConnection().getUsername() == null) {
                                tracIssueLoader = this;
                                // MONITORENTER : tracIssueLoader
                                configuration = null;
                                this.configuration = null;
                                // MONITOREXIT : tracIssueLoader
                                continue;
                            }
                            queryClient.login();
                        }
                        catch (Exception ex) {
                            TracPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                            configuration.getConnection().showError("Connection failed.", ex);
                            TracIssueLoader ex2 = this;
                            // MONITORENTER : ex2
                            configuration = null;
                            this.configuration = null;
                            // MONITOREXIT : ex2
                            continue;
                        }
                        List<TracIssueVersion> unreleasedVersionsInOrder = queryClient.getUnreleasedVersionsInOrder();
                        List<TracIssueMilestone> incompleteMilestonesInOrder = queryClient.getIncompleteMilestonesInOrder();
                        TracIssueLoader tracIssueLoader2 = this;
                        // MONITORENTER : tracIssueLoader2
                        List<TracIssueVersion> unreleasedVersions = TracIssueLoader.restrictUnreleasedVersions(unreleasedVersionsInOrder);
                        List<TracIssueMilestone> incompleteMilestones = TracIssueLoader.restrictIncompleteMilestones(incompleteMilestonesInOrder);
                        // MONITOREXIT : tracIssueLoader2
                        if (configuration.isLoadAll()) {
                            this.tableUpdater.load(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                            continue;
                        }
                        String username = configuration.getConnection().getUsername();
                        this.tableUpdater.load(username, Arrays.asList(TracIssueStatus.ACCEPTED), Collections.emptyList(), Collections.emptyList());
                        this.tableUpdater.load(username, Arrays.asList(TracIssueStatus.ASSIGNED, TracIssueStatus.REOPENED, TracIssueStatus.NEW), unreleasedVersions, incompleteMilestones);
                    }
                    catch (Exception ex) {
                        TracPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                        configuration.getConnection().showError("Connection failed.", ex);
                    }
                    TracIssueLoader ex = this;
                    // MONITORENTER : ex
                    this.configuration = null;
                    // MONITOREXIT : ex
                }
            }
            catch (Throwable ex) {
                TracPlugin.LOGGER.error(ex.getMessage(), ex);
                continue;
            }
            break;
        }
    }

    public synchronized void load(@Nullable TracQueryConfiguration configuration, boolean forceRefresh) {
        this.configuration = configuration;
        this.forceRefresh = forceRefresh;
        this.notifyAll();
    }

    public synchronized void abortAndCleanup() {
        this.aborted = true;
        if (this.tableUpdater != null) {
            this.tableUpdater.abort();
        }
        this.notifyAll();
    }

    @NotNull
    private static List<TracIssueVersion> restrictUnreleasedVersions(@NotNull List<TracIssueVersion> unreleasedVersions) {
        if (unreleasedVersions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TracIssueVersion> firstUnreleasedVersions = new ArrayList<TracIssueVersion>();
        for (int index = 0; index < Math.min(UNRELEASED_VERSIONS_TO_DISPLAY, unreleasedVersions.size()); ++index) {
            firstUnreleasedVersions.add(unreleasedVersions.get(index));
        }
        return firstUnreleasedVersions;
    }

    @NotNull
    private static List<TracIssueMilestone> restrictIncompleteMilestones(@NotNull List<TracIssueMilestone> incompleteMilestones) {
        if (incompleteMilestones.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TracIssueMilestone> firstIncompleteMilestones = new ArrayList<TracIssueMilestone>();
        for (int index = 0; index < Math.min(INCOMPLETE_MILESTONES_TO_DISPLAY, incompleteMilestones.size()); ++index) {
            firstIncompleteMilestones.add(incompleteMilestones.get(index));
        }
        return firstIncompleteMilestones;
    }

    private static boolean areConfigurationsEqual(@Nullable TracQueryConfiguration configuration1, @Nullable TracQueryConfiguration configuration2) {
        if (configuration1 == null) {
            return configuration2 == null;
        }
        return configuration2 != null && configuration1.getConnection().getUrl().equals(configuration2.getConnection().getUrl());
    }

    static {
        int unreleasedVersions = 3;
        try {
            unreleasedVersions = Integer.parseInt(System.getProperty("smartsvn.plugin.trac.unreleased-versions-to-display", String.valueOf(unreleasedVersions)));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        UNRELEASED_VERSIONS_TO_DISPLAY = unreleasedVersions;
        int incompleteMilestones = 3;
        try {
            incompleteMilestones = Integer.parseInt(System.getProperty("smartsvn.plugin.trac.incomplete-milestones-to-display", String.valueOf(incompleteMilestones)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        INCOMPLETE_MILESTONES_TO_DISPLAY = incompleteMilestones;
    }
}

