/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.plugin.trac.commit.messagesource.TracIssueList;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueTable;
import com.syntevo.plugin.trac.transport.JsonRpcException;
import com.syntevo.plugin.trac.transport.TracIssue;
import com.syntevo.plugin.trac.transport.TracIssueMilestone;
import com.syntevo.plugin.trac.transport.TracIssueStatus;
import com.syntevo.plugin.trac.transport.TracIssueVersion;
import com.syntevo.plugin.trac.transport.TracJsonRpcClient;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracIssueLoaderTableUpdater {
    private final TracJsonRpcClient client;
    private final TracIssueList issueList;
    private final TracIssueTable table;
    private boolean aborted;

    public TracIssueLoaderTableUpdater(@NotNull TracJsonRpcClient client, @NotNull TracIssueList issueList, @NotNull TracIssueTable table) {
        this.client = client;
        this.issueList = issueList;
        this.table = table;
    }

    public void load(@Nullable String assignee, @NotNull List<TracIssueStatus> states, @NotNull List<TracIssueVersion> fixVersions, @NotNull List<TracIssueMilestone> fixMilestones) throws IOException, JsonRpcException {
        boolean start = true;
        while (!this.aborted) {
            List<TracIssue> fetchedIssues;
            if (start) {
                start = false;
                fetchedIssues = this.client.getFirstIssues(assignee, states, fixVersions, fixMilestones, 100);
            } else {
                fetchedIssues = this.client.getNextIssues();
            }
            this.issueList.addIssues(fetchedIssues);
            this.table.setIssues(this.issueList.getIssuesInOrder(fixVersions, fixMilestones));
            if (!fetchedIssues.isEmpty()) continue;
            return;
        }
    }

    public void abort() {
        this.aborted = true;
    }
}

