/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitWorkflowServices;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterCommitWorkflow;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitWorkflow;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.plugin.trac.commit.workflow.TracFilesPhase;
import com.syntevo.plugin.trac.commit.workflow.TracPostCommandPhase;
import com.syntevo.plugin.trac.commit.workflow.TracResolvePacket;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class TracCommitWorkflow
extends FilterCommitWorkflow {
    private final List<ICommitPacketPhase> packetPhases;
    private final CommitWorkflowServices services;
    private TracFilesPhase filesPhase;

    public TracCommitWorkflow(@NotNull ICommitWorkflow baseWorkflow, @NotNull CommitWorkflowServices services, @NotNull SettingsServices settingsServices, @NotNull GuiSpacings spacings) {
        super(baseWorkflow);
        this.services = services;
        this.packetPhases = new ArrayList<ICommitPacketPhase>();
        for (ICommitPacketPhase phase : new ArrayList(baseWorkflow.getPacketPhases())) {
            if (phase.getID().equals("files")) {
                this.filesPhase = new TracFilesPhase(phase, settingsServices, services.getPacketPhaseJobRunner(), spacings, services.getPacketPhaseDialogDisplayer());
                this.packetPhases.add((ICommitPacketPhase)this.filesPhase);
                continue;
            }
            this.packetPhases.add(phase);
        }
    }

    @NotNull
    public List<ICommitPacketPhase> getPacketPhases() {
        return this.packetPhases;
    }

    @NotNull
    public ICommitPostCommandPhase getPostCommandPhase() {
        ICommitPostCommandPhase wrappedPhase = super.getPostCommandPhase();
        if (this.filesPhase == null) {
            return wrappedPhase;
        }
        List<TracResolvePacket> resolvePackets = this.filesPhase.getResolvePackets();
        if (resolvePackets == null || resolvePackets.isEmpty()) {
            return wrappedPhase;
        }
        return new TracPostCommandPhase(wrappedPhase, resolvePackets, this.services.getPrePostCommandPhaseDialogDisplayer());
    }
}

