/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.transport;

import com.syntevo.plugin.common.bugtracker.transport.BugtrackerClient;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerConnection;
import com.syntevo.plugin.common.bugtracker.transport.BugtrackerHttpsHostnameVerifier;
import java.io.IOException;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import sun.misc.BASE64Encoder;

class TracClient
extends BugtrackerClient {
    private static final String PROPERTY_AUTHORIZATION = "Authorization";
    private static final String PROPERTY_CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String PREFIX_BASIC_AUTH = "Basic ";

    TracClient(@NotNull BugtrackerConnection bugtrackerConnection) {
        super(bugtrackerConnection);
    }

    @Override
    public void configureConnection(@NotNull URLConnection urlConnection) throws IOException {
        String tracUser;
        if (urlConnection instanceof HttpsURLConnection) {
            SSLContext context = TracClient.createSSLContext(this.getBugtrackerConnection());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new BugtrackerHttpsHostnameVerifier());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(context.getSocketFactory());
        }
        if ((tracUser = this.getBugtrackerConnection().getUsername()) != null && !tracUser.isEmpty()) {
            String tracUserPass = this.getBugtrackerConnection().getPassword();
            String tracAuth = tracUser;
            if (tracUserPass != null && !tracUserPass.isEmpty()) {
                tracAuth = tracAuth + ":" + tracUserPass;
            }
            String encoding = new BASE64Encoder().encode(tracAuth.getBytes());
            urlConnection.setRequestProperty(PROPERTY_AUTHORIZATION, PREFIX_BASIC_AUTH + encoding);
        }
        urlConnection.setRequestProperty(PROPERTY_CONTENT_TYPE, CONTENT_TYPE_JSON);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
    }
}

