/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TracIssueResolution {
    public static final TracIssueResolution FIXED = new TracIssueResolution(System.getProperty("smartsvn.plugin.trac.resolved-constant", "fixed"));
    public static final TracIssueResolution INVALID = new TracIssueResolution("invalid");
    public static final TracIssueResolution WONT_FIX = new TracIssueResolution("wontfix");
    public static final TracIssueResolution DUPLICATE = new TracIssueResolution("duplicate");
    public static final TracIssueResolution WORKS_FOR_ME = new TracIssueResolution("worksforme");
    public static final TracIssueResolution UNKNOWN = new TracIssueResolution("unknown");
    public static final List<TracIssueResolution> ALL = Collections.unmodifiableList(Arrays.asList(FIXED, INVALID, WONT_FIX, DUPLICATE, WORKS_FOR_ME, UNKNOWN));
    private final String tracId;

    public static TracIssueResolution parseFromId(String tracId) {
        for (TracIssueResolution resolution : ALL) {
            if (resolution.tracId == null || !resolution.tracId.equals(tracId)) continue;
            return resolution;
        }
        return UNKNOWN;
    }

    public TracIssueResolution(@NotNull String tracId) {
        this.tracId = tracId;
    }

    public String toString() {
        return this.tracId;
    }
}

