/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TracIssueStatus {
    public static final TracIssueStatus ACCEPTED = new TracIssueStatus("accepted", "Accepted", 1);
    public static final TracIssueStatus ASSIGNED = new TracIssueStatus("assigned", "Assigned", 2);
    public static final TracIssueStatus REOPENED = new TracIssueStatus("reopened", "Reopened", 3);
    public static final TracIssueStatus NEW = new TracIssueStatus("new", "New", 4);
    public static final TracIssueStatus CLOSED = new TracIssueStatus("closed", "Closed", 5);
    public static final TracIssueStatus UNKNOWN = new TracIssueStatus("unknown", "???", 6);
    public static final List<TracIssueStatus> ALL = Collections.unmodifiableList(Arrays.asList(ACCEPTED, ASSIGNED, CLOSED, NEW, REOPENED, UNKNOWN));
    private final String tracId;
    private final String name;
    private final int priority;

    public static TracIssueStatus parseFromId(String tracId) {
        for (TracIssueStatus status : ALL) {
            if (status.tracId == null || !status.tracId.equals(tracId)) continue;
            return status;
        }
        return UNKNOWN;
    }

    public TracIssueStatus(String tracId, String name, int priority) {
        this.tracId = tracId;
        this.name = name;
        this.priority = priority;
    }

    public String toString() {
        return this.tracId;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }
}

