/*
 * Copyright (c) 2011 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.gui.dialog;

import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

/**
 * The base class for all GUI dialogs.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public abstract class AbstractDialog {

	// Abstract ===============================================================

	/**
	 * Returns the content component, e.g. a JPanel.
	 * Implement this method to create the dialog content.
	 * @param parent
	 */
	@NotNull
	public abstract Control createComponent(@NotNull Composite parent);

	/**
	 * Initializes the button panel and returns the default button.
	 * Implement this method to initialize the button panel.
	 */
	@NotNull
	public abstract Button initButtonPanel(@NotNull ButtonPanel buttonPanel);

	/**
	 * Returns the dialog's title.
	 */
	@NotNull
	public abstract String getTitle();

	// Constants ==============================================================

	/**
	 * 'Cancel' result for dialog closing. Signals that no subsequent action should be taken.
	 */
	public static final int RESULT_CANCEL = -1;

	/**
	 * 'Ok' result for dialog closing. Signals that the subsequent action should be taken.
	 */
	public static final int RESULT_OK = 2;

	/**
	 * The 'Cancel' or 'Close' button type.
	 * The button type affects the horizontal positioning of the button, depending on the operation system.
	 */
	public static final int BUTTON_TYPE_CANCEL = 0;

	/**
	 * The affirmation button type (like for 'OK' or 'Save' buttons).
	 * The button type affects the horizontal positioning of the button, depending on the operation system.
	 */
	public static final int BUTTON_TYPE_AFFIRMATION = 1;

	/**
	 * The dangerous affirmation button type (like for a 'Discard' button).
	 * The button type affects the horizontal positioning of the button, depending on the operation system.
	 */
	public static final int BUTTON_TYPE_AFFIRMATION_DANGEROUS = 2;

	/**
	 * The button type for other buttons than OK, Cancel or Close.
	 * The button type affects the horizontal positioning of the button, depending on the operation system.
	 */
	public static final int BUTTON_TYPE_OTHER = 3;

	// Fields =================================================================

	private InternalHandler internalHandler;

	// Accessing ==============================================================

	/**
	 * Internal code, don't call yourself.
	 */
	public final void internalSetHandler(@NotNull InternalHandler internalHandler) {
		this.internalHandler = internalHandler;
	}

	/**
	 * This method is invoked immediately after showing the dialog.
	 * Override it to request the initial focused component.
	 */
	public void dialogShowing() {
	}

	/**
	 * Close the dialog with 'Cancel' result.
	 */
	public void close() {
		close(RESULT_CANCEL);
	}

	/**
	 * Perform 'OK' code and close the dialog with 'OK' result.
	 * Override this method if you need to handle specific code on 'OK'.
	 */
	protected void performOk() {
		close(RESULT_OK);
	}

	/**
	 * Close the dialog with the specified result.
	 *
	 * @param resultValue of the dialog
	 */
	protected void close(int resultValue) {
		internalHandler.close(resultValue);
	}

	/**
	 * Let SmartSVN handle the specified input failure.
	 *
	 * @param ex the input failure
	 */
	protected void handleInputFailure(@NotNull DialogValidationFailedException ex) {
		internalHandler.handleInputFailure(ex);
	}

	// Inner Classes ==========================================================

	/**
	 * The base class of all button actions.
	 */
	public abstract class ButtonAction {
		public abstract void performAction();

		private final int type;

		private String name;

		public ButtonAction(@NotNull String name, int type) {
			this.name = name;
			this.type = type;
		}

		@NotNull
		public final String getName() {
			return name;
		}

		public final void setName(@NotNull String name) {
			this.name = name;
		}

		public final int getType() {
			return type;
		}

		public void setEnabled(boolean enabled) {
		}
	}

	/**
	 * The button panel. Add all ButtonAction objects which should be used
	 * to this object.
	 */
	public interface ButtonPanel {
		@NotNull
		Button addButton(@NotNull ButtonAction action);
	}

	/**
	 * Internal class.
	 */
	public interface InternalHandler {
		void handleInputFailure(@NotNull DialogValidationFailedException ex);

		void close(int resultValue);
	}
}
