/*
 * Copyright (c) 2011 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.gui.dialog;

import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

/**
 * A basic OK-Cancel dialog which optionally validates input.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public abstract class AbstractOkCancelDialog extends AbstractDialog {

	// Fields =================================================================

	@NotNull
	private final ButtonAction okAction;
	@NotNull
	private final ButtonAction cancelAction;

	// Setup ==================================================================

	protected AbstractOkCancelDialog() {
		okAction = new ButtonAction("OK", BUTTON_TYPE_AFFIRMATION) {
			@Override
			public void performAction() {
				performOk();
			}
		};
		cancelAction = new ButtonAction("Cancel", BUTTON_TYPE_CANCEL) {
			@Override
			public void performAction() {
				close();
			}
		};
	}

	// Implemented ============================================================

	@NotNull
	@Override
	public Button initButtonPanel(@NotNull ButtonPanel buttonPanel) {
		final Button okButton = buttonPanel.addButton(okAction);
		buttonPanel.addButton(cancelAction);
		return okButton;
	}

	@Override
	protected void performOk() {
		try {
			ok();
		}
		catch (DialogValidationFailedException ex) {
			handleInputFailure(ex);
			return;
		}

		super.performOk();
	}

	// Accessing ==============================================================

	@NotNull
	public ButtonAction getOkAction() {
		return okAction;
	}

	@NotNull
	public ButtonAction getCancelAction() {
		return cancelAction;
	}

	/**
	 * Override this method with input validation code.
	 *
	 * @throws DialogValidationFailedException in case of input failure.
	 */
	protected void ok() throws DialogValidationFailedException {
	}
}
