/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.gui.dialog;

import java.io.*;

import org.jetbrains.annotations.*;

/**
 * This class handles dialog displaying.
 * When showing multiple dialogs using this instance, the dialogs will be shown correctly on top of each other.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface DialogDisplayer {

	/**
	 * Shows a default error dialog and immediately returns.
	 * This method must be invoked from the SWT-thread.
	 *
	 * @param title  the dialog title
	 * @param message  the dialog message
	 * @param furtherInformation  optional further details (printed with smaller font size)
	 */
	void showErrorDialogAsync(@NotNull String title, @NotNull String message, @Nullable String furtherInformation, @Nullable IDialogResultHandler resultHandler);

	/**
	 * Shows a default error dialog.
	 * This method must only be called from a non-SWT-thread.
	 *
	 * @param title  the dialog title
	 * @param message  the dialog message
	 * @param furtherInformation  optional further details (printed with smaller font size)
	 */
	void showErrorDialogSync(@NotNull String title, @NotNull String message, @Nullable String furtherInformation);

	/**
	 * Shows a more specific error dialog for I/O exceptions.
	 * This method must only be called from a non-SWT-thread.
	 *
	 * @param ex  the IOException to show the dialog for
	 */
	void showIoExceptionDialogSync(@NotNull IOException ex);

	/**
	 * Shows a default confirmation dialog.
	 * This method must be invoked from the SWT-thread.
	 *
	 * @param title  the dialog title
	 * @param message  the dialog message
	 * @param furtherInformation  optional further details (printed with smaller font size)
	 * @param okText  text used for the OK button, if null, "OK" will be used
	 * @param dangerous  signals that by default the "Cancel" button should be focused
	 * @param resultHandler will be invoked when the user closed the dialog
	 */
	void showConfirmationDialogAsync(@NotNull String title, @NotNull String message, @Nullable String furtherInformation, @NotNull String okText, boolean dangerous, @NotNull IDialogResultHandler resultHandler);

	/**
	 * Shows a default confirmation dialog.
	 * This method must only be called from a non-SWT-thread.
	 *
	 * @param title  the dialog title
	 * @param message  the dialog message
	 * @param furtherInformation  optional further details (printed with smaller font size)
	 * @param okText  text used for the OK button, if null, "OK" will be used
	 * @param dangerous  signals that by default the "Cancel" button should be focused
	 * @return true  if the OK-button has been selected
	 */
	boolean showConfirmationDialogSync(@NotNull String title, @NotNull String message, @Nullable String furtherInformation, @NotNull String okText, boolean dangerous);

	/**
	 * Shows a generic dialog.
	 * This method must be invoked from the SWT-thread.
	 *
	 * @param dialog  the generic dialog to display
	 */
	void showAsync(@NotNull AbstractDialog dialog, @NotNull IDialogResultHandler resultHandler);

	/**
	 * Shows a generic dialog.
	 * This method must only be called from a non-SWT-thread.
	 */
	@Nullable
	<D extends AbstractDialog> D showSync(@NotNull IDialogFactory<D> dialogFactory);
}
