/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.gui.dialog;

import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

/**
 * An Exception signalling an input failure.
 * @see AbstractOkCancelDialog
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public class DialogValidationFailedException extends Exception {

	// Fields =================================================================

	private final Control component;
	private final String details;

	// Setup ==================================================================

	/**
	 * @param component the component containing the input failure; if possible
	 *                  this component will receive the focus after the error
	 *                  has been displayed
	 * @param message   the (short) error message to be displayed
	 * @param details   the (longer) detailed information to be displayed
	 */
	public DialogValidationFailedException(@NotNull Control component, @NotNull String message, @Nullable String details) {
		super(message);

		this.component = component;
		this.details = details;
	}

	// Accessing ==============================================================

	/**
	 * Returns the component containing the input failure.
	 */
	@NotNull
	public Control getComponent() {
		return component;
	}

	/**
	 * Returns the detail information which should be shown.
	 */
	@Nullable
	public String getDetails() {
		return details;
	}
}
