/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.command.update.*;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.io.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.openapi.deprecated.smartsvn.tagbranch.*;

/**
 * The main service object through which almost all aspects of the API are accessible.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface SmartSvnServices {

	/**
	 * Returns file-utility-related services
	 */
	@NotNull
	FileServices getFileServices();

	/**
	 * Returns settings-related services
	 */
	@NotNull
	SettingsServices getSettingsServices();

	/**
	 * Returns the known tag-branch layouts.
	 */
	@NotNull
	SvnTagBranchLayouts getTagBranchLayouts();

	/**
	 * Returns spacings information for GUI layouts.
	 */
	@NotNull
	GuiSpacings getGuiSpacings();

	/**
	 * Adds the specified IActionProvider which contributes actions to SmartSVN's project window.
	 *
	 * @param actionProvider to add
	 */
	void addProjectActionProvider(@NotNull IActionProvider actionProvider);

	/**
	 * Adds the specified ICommitWorkflowFactory which can be used to customize the commit workflow/process.
	 *
	 * @param commitWorkflowFactory to add
	 */
	void addCommitWorkflowFactory(@NotNull ICommitWorkflowFactory commitWorkflowFactory);

	/**
	 * Adds the specified IUpdateWorkflowFactory which can be used to customize the update workflow/process.
	 *
	 * @param updateWorkflowFactory to add
	 */
	void addUpdateWorkflowFactory(@NotNull IUpdateWorkflowFactory updateWorkflowFactory);

	/**
	 * Adds the specified IFileExtendedAttributeHandler which can be used to display custom file table columns.
	 *
	 * @param fileTableColumn to add
	 */
	void addFileTableColumn(@NotNull ISvnFileTableColumn fileTableColumn);

	/**
	 * Adds the specified ISvnFileFilter which will be added to the file table's filter input field popup menu.
	 *
	 * @param fileFilter to add
	 */
	void addFileFilter(@NotNull ISvnFileFilter fileFilter);

	/**
	 * Adds the specified ICommitMessageSourceFactory which can be used to provide additional sources for
	 * selecting a commit message (besides 'Get from Log').
	 *
	 * @param commitMessageSourceFactory to add
	 */
	void addCommitMessageSourceFactory(@NotNull ICommitMessageSourceFactory commitMessageSourceFactory);
}
