/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.command.commit;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.command.*;

/**
 * The configuration of SmartSVN's commit operation (including the wizard phases).
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface CommitConfiguration {

	/**
	 * Returns depth for scanning for committable files/directories.
	 */
	@Nullable
	SvnDepth getDepth();

	/**
	 * Sets the depth for scanning for committable files/directories.
	 */
	void setDepth(@Nullable SvnDepth depth);

	/**
	 * Tests whether to descend into externals when scanning for committable files/directories.
	 *
	 * @return true to descend into externals
	 */
	boolean isDescendIntoExternals();

	/**
	 * Sets whether to descend into externals when scanning for committable files/directories.
	 */
	void setDescendIntoExternals(boolean descendIntoExternals);

	/**
	 * Tests whether to skip committable files/directories assigned to Change Sets or SVN's changelists.
	 *
	 * @return true to skip committable files/directories assigned to Change Sets
	 */
	boolean isSkipChangeSetOrChangelistEntries();

	/**
	 * Sets whether to skip committable files/directories assigned to Change Sets or SVN's changelists.
	 */
	void setSkipChangeSetOrChangelistEntries(boolean skipChangeSetOrChangelistEntries);

	/**
 	 * Tests whether to suggest unversioned files for addition.
	 *
 	 * @return true to suggest unversioned files for addition
	 */
	boolean isAddUnversioned();

	/**
 	 * Sets whether to suggest unversioned files for addition.
	 */
	void setAddUnversioned(boolean addUnversioned);

	/**
 	 * Tests whether to suggest missing files for removal
	 *
 	 * @return true to suggest missing files for removal
	 */
	boolean isRemoveMissing();

	/**
 	 * Set whether to suggest missing files for removal.
	 */
	void setRemoveMissing(boolean removeMissing);

	/**
 	 * Tests whether to detect possibly moved files (by inspecting unversioned/missing file pairs).
	 *
 	 * @return true to detect possibly moved files
	 * @see CommitMoveSuggestion
	 */
	boolean isDetectMoves();

	/**
 	 * Sets whether to detect possibly moved files (by inspecting unversioned/missing file pairs).
	 */
	void setDetectMoves(boolean smartMove);

	/**
 	 * Tests whether to suggest removed parent directories for removal.
	 *
 	 * @return true to suggest removed parent directories for removal
	 */
	boolean isIncludeRemovedParents();

	/**
 	 * Sets whether to suggest removed parent directories for removal.
	 */
	void setIncludeRemovedParents(boolean includeRemovedParents);

	/**
 	 * Tests whether to suggest resulting empty parent directories for removal.
	 *
 	 * @return true to suggest resulting empty parent directories for removal
	 */
	boolean isIncludeEmptyParents();

	/**
 	 * Sets whether to suggest resulting empty parent directories for removal
	 */
	void setIncludeEmptyParents(boolean includeEmptyParents);
}
