/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.command.commit;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.project.*;

/**
 * A commit packet phase, see {@link ICommitWorkflow} for details.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface ICommitPacketPhase {

	/**
	 * Returns the ID of the phase. May be used to identify default phases:
	 * "detect-moves", "externals", "files" and "locks".
	 * @return id
	 */
	@NotNull
	String getID();

	/**
	 * Returns the UI to be used, must not be null
	 * @return UI
	 */
	@NotNull
	ICommitPhaseUi getUi();

	/**
	 * Initialize the phase from the specified project. This method is called before the
	 * configuration phase is executed.
	 * @param project to set
	 */
	void initialize(@NotNull Project project);

	/**
	 * Tests whether this phase is applicable to the specified set of {@link CommitPacket} objects.
	 * In case of false, the corresponding wizard page will not be displayed.
	 *
	 * @param state to set
	 * @return true if applicable
	 */
	boolean isApplicable(@NotNull CommitPacketPhaseState state);

	/**
	 * Update the phase from the specified set of {@link CommitPacket} objects.
	 * @param state to set
	 */
	void updateFrom(@NotNull CommitPacketPhaseState state);

	/**
	 * Update the specified set of {@link CommitPacket} objects from the phase.
	 *
	 *
	 * @param state to set
	 * @param successRunnable must be executed on successful completion
	 */
	void updateTo(@NotNull CommitPacketPhaseState state, @NotNull Runnable successRunnable);

	/**
	 * This method is called immediately before the corresponding wizard card will be displayed.
	 */
	void beforeShowing();

	/**
	 * Do necessary cleanup.
	 *
	 * @param cancelled is false only if the commit wizard has been closed by 'OK' or 'Finish'.
	 */
	void cleanup(boolean cancelled);
}
