/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.command.commit;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * An ICommitWorkflow can be used to customize the workflow of the commit
 * operation. The workflow of the commit operation is separated into various phases:
 * <ul>
 * <li>The configuration phase {@link ICommitConfigurationPhase}, which basically
 *   configures the scanning for committable files and directories.
 *   The result of the configuration phase is a set of commit packets {@link CommitPacket}
 *   which contain found committable files/directories, locked files, etc. which
 *   can be altered by the subsequent packet phases.</li>
 * <li>The scanning phase itself</li>
 * <li>Several packet phases {@link ICommitPacketPhase}, as found in the Commit Wizard.
 *   Individual packet phases can be dropped or added. Packet phases are altering
 *   the set of commit packets {@link CommitPacket}.</li>
 * <li>The pre-commit phase {@link ICommitPreCommandPhase} which is executed after the
 *   user has confirmed the Commit wizard with 'OK' and directly before the actual
 *   commit happens. This phases basically gets the same information as a
 *   {@link ICommitPacketPhase}, but information is read-only now. It can be used
 *   to assign special properties to files/directories or perform other non-UI related
 *   tasks on the committable files/directories.<br/>
 *   Furthermore, complete packets can be skipped.<br/>
 *   If you need to manipulate the set of committables without having a separate
 *   wizard page, get the "files" packet phase and override {@link ICommitPacketPhase#updateFrom(CommitPacketPhaseState)}
 *   as well as {@link ICommitPacketPhase#updateTo(CommitPacketPhaseState, Runnable)}.</li>
 * <li>The post-command phase {@link ICommitPostCommandPhase} which is executed after a
 *   <b>successful</b> commit. It receives the actually committed files/directories
 *   and the corresponding {@link org.apache.subversion.javahl.ClientNotifyInformation} objects. It can
 *   be used for all kinds of post-processing a commit.</li>
 * </ul>
 * NOTE: The phase objects returned must not change between calls!
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface ICommitWorkflow {

	/**
	 * Returns the configuration phase
	 */
	@NotNull
	ICommitConfigurationPhase getConfigurationPhase();

	/**
	 * Returns the set of {@link ICommitPacketPhase}.
	 */
	@NotNull
	List<ICommitPacketPhase> getPacketPhases();

	/**
	 * This method is after the scanning phase has been finished and before the first packet phase
	 * is entered. It receives the original set of {@link CommitPacket} objects and can be used
	 * to filter out committable files/directories.
	 *
	 * This method is called from within the worker thread, so it may be used for time-consuming
	 * preparations as well.
	 *
	 * @return the set of {@link ICommitPacketPhase}; null or an empty set indicates that the
	 * commit is not possible and forces SmartSVN to return the configuration page.
	 */
	@NotNull
	Set<CommitPacket> prepareForPacketPhases(@NotNull Set<CommitPacket> packets);

	/**
	 * Returns the pre-commit phase
	 */
	@NotNull
	ICommitPreCommandPhase getPreCommandPhase();

	/**
	 * Returns the post-commit phase
	 */
	@NotNull
	ICommitPostCommandPhase getPostCommandPhase();
}
