/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.file.gui;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;

/**
 * An action which can work on files/directories of the Project window.
 * Use {@link ActionRegisterService#registerAction(String, ISvnFileDirectoryAction)} to
 * register the action.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface ISvnFileDirectoryAction {

	/**
	 * Tests whether the action is either applicable to the specified selected files or directories.
	 *
	 * @return true if applicable
	 */
	boolean isApplicable(@NotNull SelectedSvnFiles selectedFiles, @NotNull SelectedSvnDirectories selectedDirectories);

	/**
	 * Executes the action on the specified files. For the execution of the action, the provided {@link ActionServices}
	 * may be used.
	 * @param entryQuery a query object which can be used to retrieve more information on SvnEntry objects
	 *
	 * @since 6.1
	 */
	void execute(@NotNull SelectedSvnFiles selectedFiles, @NotNull SvnEntryQuery entryQuery, @NotNull ActionServices services);

	/**
	 * Executes the action on the specified directories. For the execution of the action, the provided
	 * {@link ActionServices} may be used.
	 * @param entryQuery a query object which can be used to retrieve more information on SvnEntry objects
	 *
	 * @since 6.1
	 */
	void execute(@NotNull SelectedSvnDirectories selectedDirectories, @NotNull SvnEntryQuery entryQuery, @NotNull ActionServices services);
}
