/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.gui.menu;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.file.gui.*;

/**
 * Use this instance to insert menu items, separators or sub menus to the menu.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface MenuStructure extends MenuItem, MenuContainer {

	/**
	 * @return "menu"
	 */
	@Override
	@NotNull
	String getType();

	/**
	 * Returns the name of the menu as it is displayed
	 */
	@NotNull
	String getMenuName();

	/**
	 * Add a menu item to the menu.
	 *
	 * @param index                       the index within this menu structure to add the action at
	 * @param id                          use the same action ID when registering the action instance with {@link ActionRegisterService#registerAction(String, ISvnFileDirectoryAction)}
	 * @param accelerator                 the SWT modifier constant (e.g. SWT.SHIFT | SWT.COMMAND) or-combined with the SWT key constant (e.g. SWT.F1) for the menu item's default accelerator, 0 if none
	 * @param name                        the menu item name shown in the menu
	 * @param toolTip                     the menu item tooltip shown in the status bar when hovering over the menu item (except for Mac OS&nbsp;X)
	 * @param availableForFileContextMenu true if the user should be able to put this menu item in the file context menu
	 * @param availableForDirectoryContextMenu true if the user should be able to put this menu item in the directory context menu
	 */
	void addAction(int index, @NotNull String id, int accelerator, @NotNull String name, @NotNull String toolTip, boolean availableForFileContextMenu, boolean availableForDirectoryContextMenu);

	/**
	 * Add a separator to the menu.
	 *
	 * @param index the index within this menu structure to add the separator at
	 */
	void addSeparator(int index);
}
