package com.syntevo.openapi.deprecated.smartsvn.gui.menu;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * Utility methods regarding the manipluation of SmartSVN's main menu bar.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public final class MenuUtils {

	// Static =================================================================

	public static boolean insertActionBefore(@NotNull String insertionPoint, @NotNull String id, int accelerator, @NotNull String name, @NotNull String toolTip, boolean availableForFileContextMenu, boolean availableForDirectoryContextMenu, @NotNull MenuContainer menuContainer) {
		final MenuStructure structure = getMenuStructureForActionId(insertionPoint, menuContainer);
		if (structure == null) {
			return false;
		}

		final int insertionIndex = getIndexOfActionId(insertionPoint, structure);
		structure.addAction(insertionIndex, id, accelerator, name, toolTip, availableForFileContextMenu, availableForDirectoryContextMenu);
		return true;
	}

	public static boolean insertActionAfter(@NotNull String insertionPoint, @NotNull String id, int accelerator, @NotNull String name, @NotNull String toolTip, boolean availableForFileContextMenu, boolean availableForDirectoryContextMenu, @NotNull MenuContainer menuContainer) {
		final MenuStructure structure = getMenuStructureForActionId(insertionPoint, menuContainer);
		if (structure == null) {
			return false;
		}

		final int insertionIndex = getIndexOfActionId(insertionPoint, structure);
		structure.addAction(insertionIndex + 1, id, accelerator, name, toolTip, availableForFileContextMenu, availableForDirectoryContextMenu);
		return true;
	}

	@Nullable
	public static MenuStructure getMenuStructureForActionId(@NotNull String insertionPoint, @NotNull MenuContainer menuContainer) {
		for (final Iterator it = menuContainer.getItems().iterator(); it.hasNext();) {
			final MenuItem item = (MenuItem)it.next();
			if (item instanceof MenuAction && ((MenuAction)item).getId().equals(insertionPoint)) {
				return (MenuStructure)menuContainer;
			}
			if (item instanceof MenuContainer) {
				final MenuStructure foundStructure = getMenuStructureForActionId(insertionPoint, (MenuContainer)item);
				if (foundStructure != null) {
					return foundStructure;
				}
			}
		}

		return null;
	}

	public static int getIndexOfActionId(@NotNull String insertionPoint, @NotNull MenuStructure structure) {
		final List items = structure.getItems();
		for (int index = 0; index < items.size(); index++) {
			final MenuItem item = (MenuItem)items.get(index);
			if (item instanceof MenuAction && ((MenuAction)item).getId().equals(insertionPoint)) {
				return index;
			}
		}

		return -1;
	}

	// Setup ==================================================================

	private MenuUtils() {
	}
}
