/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.smartsvn.settings;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.dialog.*;

/**
 * A settings area for a plug-in. A settings area stores simple key-value mappings. Null values
 * can be stored. See {@link SettingsUtils} for various
 * convenience methods.
 *
 * There are global settings (Preferences) and project-related settings.
 * Every plugin has it's own settings area (identified by a key). It's strongly recommended to
 * use the Plugin-ID for the key to avoid potential confusion with other plugins.
 *
 * Plugins can access settings areas of foreign plugins as well, if they know the foreign plugin-ID,
 * or the key under which the foreign plugin stores its settings (however it's not recommended to
 * manipulate foreign settings areas).
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface Settings {

	/**
	 * Returns the value which is stored under the specified key.
	 *
	 * @param key the value's key
	 * @param defaultValue the default to be used it there is no value present for the specified key
	 */
	@Nullable
	String getString(@NotNull String key, @Nullable String defaultValue);

	/**
	 * Stores the specified value under the specified key.
	 *
	 * @param key the value's key, must not be null
	 * @param value the value, may be null
	 */
	void putString(@NotNull String key, @Nullable String value);

	/**
	 * Returns the password which is stored under the specified key.
	 * This method must only be invoked from a non-SWT-thread.
	 *
	 * @param key the password's key
	 */
	@Nullable
	String getPassword(@NotNull String key, @NotNull DialogDisplayer dialogDisplayer);

	/**
	 * Stores the specified password under the specified key.
	 * This method must only be invoked from a non-SWT-thread.
	 *
	 * @param key the value's key, must not be null
	 * @param password the password, may be null
	 */
	void putPassword(@NotNull String key, @Nullable String password, @NotNull DialogDisplayer dialogDisplayer);

	/**
	 * Removes the value for the specified key.
	 *
	 * @param key of the value to be removed
	 */
	void removeValue(@NotNull String key);
}
