package com.syntevo.openapi.deprecated.smartsvn.tagbranch;

import org.apache.subversion.javahl.*;
import org.jetbrains.annotations.*;

/**
 * A tag-branch-layout, providing functions to convert URLs to tag/branch names and vice versa.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public interface SvnTagBranchLayout {

	/**
	 * Returns whether the URL is below trunk of this layout.
	 *
	 * @param trunkUrl URL to determine whether its trunk
	 * @return true if the URL is below trunk of this layout.
	 */
	boolean isTrunk(@NotNull String trunkUrl) throws SubversionException;

	/**
	 * Returns the tag-name for the specified URL, if the URL represents a tag itself or is part of a tag.
	 *
	 * @param tagLocation URL to be converted to tag name
	 * @return the tag-name or null, if the URL does not map to a tag.
	 */
	@Nullable
	String getTagName(@NotNull String tagLocation) throws SubversionException;

	/**
	 * Return the URL for the specified tag.
	 *
	 * @param tagName name of the tag
	 * @return URL corresponding to the specified tag
	 */
	@Nullable
	String getTagLocation(@NotNull String tagName) throws SubversionException;

	/**
	 * Returns the branch-name for the specified URL, if the URL represents a branch itself or is part of a branch.
	 *
	 * @param branchLocation URL to be converted to branch name
	 * @return the branch-name or null, if the URL does not map to a branch.
	 */
	@Nullable
	String getBranchName(@NotNull String branchLocation) throws SubversionException;

	/**
	 * Return the URL for the specified tag.
	 *
	 * @param branchName name of the branch
	 * @return URL corresponding to the specified branch
	 */
	@Nullable
	String getBranchLocation(@NotNull String branchName) throws SubversionException;
}
