/*
 * Copyright (c) 2009 by syntevo GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of syntevo GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.syntevo.openapi.deprecated.util;

import org.jetbrains.annotations.*;

/**
 * Utility methods regarding the comparison of objects.
 *
 * @deprecated see http://www.syntevo.com/blog/?p=4160
 */
public class CompareUtils {

	// Static =================================================================

	public static <O extends Comparable<O>> int compare(@Nullable O comparable1, @Nullable O comparable2) {
		if (comparable1 == null) {
			if (comparable2 == null) {
				return 0;
			}
			return +1; // a null value is bigger then any other
		}
		if (comparable2 == null) {
			return -1;
		}
		return comparable1.compareTo(comparable2);
	}

	public static int compare(long long1, long long2) {
		if (long1 == long2) {
			return 0;
		}
		return long1 > long2 ? +1 : -1;
	}

	public static <E> boolean areEqual(E obj1, E obj2) {
		return (obj1 == obj2)
				|| (obj1 != null && obj1.equals(obj2));
	}

	public static <T> int compareForNull(T o1, T o2) {
		if (o1 == null) {
			if (o2 == null) {
				return 0;
			}

			return +1;
		}
		if (o2 == null) {
			return -1;
		}
		return 0;
	}
}