package com.syntevo.plugin.hidemenuitems;

import java.util.*;

import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.gui.menu.*;

/**
 * @author syntevo GmbH
 */
final class HideMenuItemsActionProvider implements IActionProvider {

	// Fields =================================================================

	private final Set idsToHide;

	// Setup ==================================================================

	public HideMenuItemsActionProvider(Set idsToHide) {
		this.idsToHide = idsToHide;
	}

	// Implemented ============================================================

	@Override
	public void modifyMenuBar(MenuContainer menuContainer) {
		final List items = menuContainer.getItems();
		for (int i = items.size(); i-- > 0;) {
			final MenuItem menuItem = (MenuItem)items.get(i);
			if (menuItem instanceof MenuStructure) {
				final MenuStructure menuStructure = (MenuStructure)menuItem;

				HideMenuItemsPlugin.LOG.debug("Processing menu " + menuStructure.getMenuName());

				modifyMenuBar(menuStructure);

				HideMenuItemsPlugin.LOG.debug("Processed menu " + menuStructure.getMenuName());
			}
			else if (menuItem instanceof MenuAction) {
				final MenuAction menuAction = (MenuAction)menuItem;

				HideMenuItemsPlugin.LOG.debug("Processing action " + menuAction.getId());

				if (idsToHide.contains(menuAction.getId())) {
					HideMenuItemsPlugin.LOG.debug("Hiding action " + menuAction.getId());

					menuContainer.removeItem(i);
				}
			}
		}
	}

	@Override
	public void createActions(ActionRegisterService service) {
	}
}
