package com.syntevo.plugin.hidemenuitems;

import java.io.*;
import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.*;
import com.syntevo.openapi.deprecated.log.*;
import com.syntevo.openapi.deprecated.smartsvn.*;
import com.syntevo.openapi.deprecated.smartsvn.gui.menu.*;

/**
 * @author syntevo GmbH
 */
public final class HideMenuItemsPlugin implements IActivator {

	// Constants ==============================================================

	static final Logger LOG = LoggerFactory.createLogger("com.syntevo.hideMenuItems");

	private static final String CONFIG_FILE_NAME = "menuItemsToHide.config";

	// Implemented ============================================================

	@Override
	public void initialize(@NotNull SmartSvnServices services) {
		final File userConfigFile = services.getSettingsServices().getSettingsFile(CONFIG_FILE_NAME);
		File configFile = userConfigFile;
		if (!configFile.exists()) {
			configFile = services.getSettingsServices().getDefaultSettingsFile(CONFIG_FILE_NAME);
			if (!configFile.exists()) {
				createDefaultConfigFile(userConfigFile);
				return;
			}
		}

		final Set idsToHide = readConfigFile(configFile);
		if (idsToHide.isEmpty()) {
			return;
		}

		services.addProjectActionProvider(new HideMenuItemsActionProvider(idsToHide));
	}

	// Utils ==================================================================

	private Set readConfigFile(File configFile) {
		final Set idsToHide = new HashSet();

		try {
			try (BufferedReader reader = new BufferedReader(new FileReader(configFile))) {
				for (String line = reader.readLine(); line != null; line = reader.readLine()) {
					line = line.trim();
					if (line.startsWith("#")) {
						continue;
					}

					idsToHide.add(line);
				}
			}
		}
		catch (IOException ex) {
			LOG.error("Error reading config file " + configFile.getAbsolutePath(), ex);
		}

		return idsToHide;
	}

	private void createDefaultConfigFile(File configFile) {
		try {
			try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile))) {
				writer.write("# Uncomment entries to hide them");
				writer.newLine();

				final List sortedIds = new ArrayList(ProjectActionIds.ALL_IDS);
				Collections.sort(sortedIds);
				for (final Iterator it = sortedIds.iterator(); it.hasNext(); ) {
					writeLine((String)it.next(), writer);
				}
			}
		}
		catch (IOException ex) {
			LOG.error("Error writing config file " + configFile.getAbsolutePath(), ex);
		}
	}

	private void writeLine(String id, BufferedWriter writer) throws IOException {
		writer.write('#');
		writer.write(id);
		writer.newLine();
	}
}
