package com.syntevo.plugin.jira.commit;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.plugin.common.bugtracker.transport.*;
import com.syntevo.plugin.jira.*;

/**
 * @author syntevo GmbH
 */
public final class JiraUIConnection extends BugtrackerUIConnection {

	// Constants ==============================================================

	private static final String PLUGIN_NAME = "JIRA";
	private static final String PLUGIN_SETTINGS_FILE = "jira-plugin.log";
	private static final boolean DEBUG_LOGGING = Boolean.getBoolean("smartsvn.plugin.jira.debug-logging");
	private static final String CREDENTIALS_DIALOG_TITLE = PLUGIN_NAME + " - Login";
	private static final String CERTIFICATE_DIALOG_TITLE = PLUGIN_NAME + " - Client Certificate";

	// Setup ==================================================================

	public JiraUIConnection(String url, SettingsServices settingsServices, boolean silent, GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
		super(url.endsWith("/") ? url : url + "/",
		      PLUGIN_NAME,
		      settingsServices.getGlobalSettingsProvider().getSettings(JiraPlugin.PLUGIN_ID),
		      settingsServices.getSettingsFile(PLUGIN_SETTINGS_FILE),
		      silent,
		      DEBUG_LOGGING,
		      CREDENTIALS_DIALOG_TITLE,
		      CERTIFICATE_DIALOG_TITLE,
		      spacings,
		      dialogDisplayer);
	}
}