package com.syntevo.plugin.jira.commit;

/**
 * @author syntevo GmbH
 */
public class JiraUrl {

	// Constants ==============================================================

	private static final String VIEW_ISSUE_SIGNATURE = "ViewIssue.jspa?key=";
	private static final String BROWSE_SIGNATURE = "browse/";

	// Static =================================================================

	public static JiraUrl parseFromBugtraqUrls(String url) {
		if (url == null) {
			return null;
		}

		final String baseUrl = extractBaseURL(url);
		final String projectKey = extractProjectKey(url);
		if (baseUrl == null || projectKey == null) {
			return null;
		}

		return new JiraUrl(baseUrl, projectKey);
	}

	// Fields =================================================================

	private final String baseUrl;
	private final String projectKey;

	// Setup ==================================================================

	public JiraUrl(String baseUrl, String projectKey) {
		this.baseUrl = baseUrl;
		this.projectKey = projectKey;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return baseUrl + "/" + projectKey;
	}

	// Accessing ==============================================================

	public String getBaseUrl() {
		return baseUrl;
	}

	public String getProjectKey() {
		return projectKey;
	}

	// Utils ==================================================================

	private static String extractBaseURL(String url) {
		final String signature = findSignature(url);
		if (signature == null) {
			return null;
		}

		final int signatureIndex = url.indexOf(signature);
		url = url.substring(0, signatureIndex);
		if (url.endsWith("/secure/")) {
			url = url.substring(0, url.length() - "/secure/".length());
		}
		return url;
	}

	private static String extractProjectKey(String url) {
		final String signature = findSignature(url);
		if (signature == null) {
			return null;
		}

		final int startIndex = url.indexOf(signature);
		url = url.substring(startIndex + signature.length());
		final int hyphenIndex = url.indexOf("-");
		if (hyphenIndex == -1) {
			return null;
		}

		return url.substring(0, hyphenIndex);
	}

	private static String findSignature(String url) {
		if (url.indexOf(VIEW_ISSUE_SIGNATURE) >= 0) {
			return VIEW_ISSUE_SIGNATURE;
		}
		if (url.indexOf(BROWSE_SIGNATURE) >= 0) {
			return BROWSE_SIGNATURE;
		}
		return null;
	}
}