package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;
import com.syntevo.plugin.common.bugtracker.commit.messagesource.*;
import com.syntevo.plugin.jira.commit.*;

/**
 * @author syntevo GmbH
 */
public final class JiraCommitMessageSourceFactory implements ICommitMessageSourceFactory {

	// Fields =================================================================

	private final SettingsServices settingsServices;
	private final GuiSpacings spacings;

	// Setup ==================================================================

	public JiraCommitMessageSourceFactory(SettingsServices settingsServices, GuiSpacings spacings) {
		this.settingsServices = settingsServices;
		this.spacings = spacings;
	}

	// Implemented ============================================================

	@Override
	public ICommitMessageSource createCommitMessageSource(CommitMessageSourceServices sourceServices) {
		final Thread currentThread = Thread.currentThread();
		final ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
		currentThread.setContextClassLoader(getClass().getClassLoader());
		try {
			final Path commitRootPath = sourceServices.getCommitRootPath();

			final String bugtraqURL = BugtrackerCommitMessageSourceUtils.findBugtraqURL(sourceServices.getClients(), commitRootPath);
			if (bugtraqURL == null) {
				return null;
			}

			final JiraUrl url = JiraUrl.parseFromBugtraqUrls(bugtraqURL);
			if (url == null) {
				return null;
			}

			final String baseUrl = url.getBaseUrl();
			if (baseUrl == null) {
				return null;
			}

			return new JiraCommitMessageSource(baseUrl, settingsServices, url.getProjectKey(), spacings, sourceServices.getDialogDisplayer());
		}
		finally {
			currentThread.setContextClassLoader(originalContextClassLoader);
		}
	}
}