package com.syntevo.plugin.jira.commit.messagesource;

import java.util.*;

import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
final class JiraIssueByRelevanceComparator implements Comparator<JiraIssue> {

	// Fields =================================================================

	private final Map<JiraIssue, Integer> issueToRelevance;

	// Setup ==================================================================

	public JiraIssueByRelevanceComparator(Map<JiraIssue, Integer> issueToRelevance) {
		this.issueToRelevance = issueToRelevance;
	}

	// Implemented ============================================================

	@Override
	public int compare(JiraIssue o1, JiraIssue o2) {
		final int relevanceComparison = issueToRelevance.get(o1).compareTo(issueToRelevance.get(o2));
		if (relevanceComparison != 0) {
			return relevanceComparison;
		}

		return -compareID(o1.getId(), o2.getId());
	}

	// Utils ==================================================================

	private static int compareID(String id1, String id2) {
		Integer id1o;
		try {
			id1o = new Integer(id1);
		}
		catch (NumberFormatException e) {
			id1o = new Integer(0);
		}

		Integer id2o;
		try {
			id2o = new Integer(id2);
		}
		catch (NumberFormatException e) {
			id2o = new Integer(0);
		}

		return id1o.compareTo(id2o);
	}
}