package com.syntevo.plugin.jira.commit.messagesource;

import java.util.*;

import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
final class JiraIssueList {

	// Fields =================================================================

	private final Map<String, JiraIssue> idToIssue;
	private final Map<JiraIssue, Integer> issueToRelevance;

	private List<JiraIssue> issuesInOrder;

	// Setup ==================================================================

	public JiraIssueList() {
		this.idToIssue = new HashMap<>();
		this.issueToRelevance = new HashMap<>();
		this.issuesInOrder = new ArrayList<>();
	}

	// Accessing ==============================================================

	public synchronized void addIssues(List<JiraIssue> issues, int relevance) {
		for (JiraIssue issue : issues) {
			final String id = issue.getId();
			final JiraIssue existingIssue = idToIssue.get(id);
			final Integer existingRelevance = issueToRelevance.get(existingIssue);
			if (existingRelevance != null && existingRelevance.intValue() <= relevance) {
				continue;
			}

			idToIssue.put(id, issue);
			issueToRelevance.put(issue, new Integer(relevance));
			issuesInOrder = null;
		}
	}

	public synchronized List<JiraIssue> getIssuesInOrder() {
		issuesInOrder = new ArrayList<>(idToIssue.values());
		Collections.sort(issuesInOrder, new JiraIssueByRelevanceComparator(issueToRelevance));
		return issuesInOrder;
	}

	public synchronized void clear() {
		idToIssue.clear();
		issueToRelevance.clear();
		
		this.issuesInOrder = null;
	}
}