package com.syntevo.plugin.jira.commit.workflow;

import java.util.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;

/**
 * @author syntevo GmbH
 */
@SuppressWarnings({"unchecked"})
final class JiraCommitWorkflow extends FilterCommitWorkflow {

	// Fields =================================================================

	private final List<ICommitPacketPhase> packetPhases;
	private final CommitWorkflowServices services;

	private JiraFilesPhase filesPhase;

	// Setup ==================================================================

	public JiraCommitWorkflow(ICommitWorkflow baseWorkflow, CommitWorkflowServices services, SettingsServices settingsServices, GuiSpacings spacings) {
		super(baseWorkflow);
		this.services = services;

		packetPhases = new ArrayList<>();
		for (ICommitPacketPhase phase : new ArrayList<>(baseWorkflow.getPacketPhases())) {
			if (phase.getID().equals("files")) {
				filesPhase = new JiraFilesPhase(phase, settingsServices, services.getPacketPhaseJobRunner(), spacings, services.getPacketPhaseDialogDisplayer());
				packetPhases.add(filesPhase);
			}
			else {
				packetPhases.add(phase);
			}
		}
	}

	// Implemented ============================================================

	@Override
	public List<ICommitPacketPhase> getPacketPhases() {
		return packetPhases;
	}

	@Override
	public ICommitPostCommandPhase getPostCommandPhase() {
		final ICommitPostCommandPhase wrappedPhase = super.getPostCommandPhase();
		if (filesPhase == null) {
			return wrappedPhase;
		}

		final List<JiraResolvePacket> resolvePackets = filesPhase.getResolvePackets();
		if (resolvePackets == null || resolvePackets.isEmpty()) {
			return wrappedPhase;
		}

		return new JiraPostCommandPhase(wrappedPhase, resolvePackets, services.getPrePostCommandPhaseDialogDisplayer());
	}
}
