package com.syntevo.plugin.jira.commit.workflow;

import java.io.*;
import java.util.*;
import javax.xml.soap.*;

import org.apache.subversion.javahl.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.dialog.*;
import com.syntevo.openapi.deprecated.smartsvn.command.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.file.*;
import com.syntevo.plugin.common.bugtracker.transport.*;
import com.syntevo.plugin.jira.*;
import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
final class JiraPostCommandPhase extends FilterPostCommandPhase {

	// Fields =================================================================

	private final List<JiraResolvePacket> resolvePackets;
	private final DialogDisplayer dialogDisplayer;

	// Setup ==================================================================

	public JiraPostCommandPhase(ICommitPostCommandPhase wrappedPhase, List<JiraResolvePacket> resolvePackets, DialogDisplayer dialogDisplayer) {
		super(wrappedPhase);
		this.resolvePackets = resolvePackets;
		this.dialogDisplayer = dialogDisplayer;
	}

	// Implemented ============================================================

	@Override
	public void process(@NotNull Map<Path, ClientNotifyInformation> pathToClientNotifyInformation, @NotNull SvnClients svnClients) throws SubversionException {
		super.process(pathToClientNotifyInformation, svnClients);

		JiraPlugin.LOGGER.debug("Resolving packets");

		for (JiraResolvePacket resolvePacket : resolvePackets) {
			JiraPlugin.LOGGER.info("Resolving " + resolvePacket);

			final BugtrackerConnection connection = resolvePacket.getConnection();
			final String issueKey = resolvePacket.getIssueKey();
			final JiraSoapClient soapClient = new JiraSoapClient(connection);
			try {
				if (!soapClient.login()) {
					JiraPlugin.LOGGER.warn("JIRA login failed, can resolveIssue " + resolvePacket);
					return;
				}

				try {
					soapClient.resolve(issueKey, connection.getUsername(), JiraIssueResolution.FIXED, resolvePacket.getFixVersion());
					JiraPlugin.LOGGER.warn(" ... resolved");
				}
				finally {
					soapClient.logout();
				}
			}
			catch (IOException ex) {
				JiraPlugin.LOGGER.error(ex.getMessage(), ex);
				dialogDisplayer.showErrorDialogSync("JIRA", ex.getMessage(), null);
			}
			catch (SOAPException ex) {
				String message = ex.getMessage();
				final int index = message.indexOf("\n");
				if (index > 0) {
					message = message.substring(0, index).trim();
				}

				JiraPlugin.LOGGER.error(message, ex);
				dialogDisplayer.showErrorDialogSync("JIRA", message, null);
			}
		}
	}
}
