package com.syntevo.plugin.jira.commit.workflow;

import java.util.*;

import com.syntevo.plugin.jira.commit.*;
import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
class JiraResolvablePacket {

	// Fields =================================================================

	private final String issueKey;
	private final String projectKey;
	private final JiraUIConnection connection;

	private JiraIssue issue;
	private List<JiraVersion> unreleasedVersions;

	// Setup ==================================================================

	public JiraResolvablePacket(String issueKey, String projectKey, JiraUIConnection connection) {
		this.issueKey = issueKey;
		this.projectKey = projectKey;
		this.connection = connection;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return issueKey;
	}

	@Override
	public int hashCode() {
		return issueKey.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}

		final JiraResolvablePacket packet = (JiraResolvablePacket)obj;
		return issueKey.equals(packet.issueKey) && projectKey.equals(packet.projectKey) && connection.getUrl().equals(packet.connection.getUrl());
	}

	// Accessing ==============================================================

	public String getIssueKey() {
		return issueKey;
	}

	public String getProjectKey() {
		return projectKey;
	}

	public JiraUIConnection getConnection() {
		return connection;
	}

	public JiraIssue getIssue() {
		return issue;
	}

	public void setIssue(JiraIssue issue) {
		this.issue = issue;
	}

	public List<JiraVersion> getUnreleasedVersions() {
		return unreleasedVersions;
	}

	public void setUnreleasedVersions(List<JiraVersion> unreleasedVersions) {
		this.unreleasedVersions = new ArrayList<>(unreleasedVersions);
	}
}
