package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.plugin.common.bugtracker.transport.*;
import com.syntevo.plugin.jira.transport.*;

/**
 * @author syntevo GmbH
 */
class JiraResolvePacket {

	// Fields =================================================================

	private final BugtrackerConnection connection;
	private final String issueKey;
	private final JiraVersion fixVersion;

	// Setup ==================================================================

	public JiraResolvePacket(BugtrackerConnection connection, String issueKey, JiraVersion fixVersion) {
		this.connection = connection;
		this.issueKey = issueKey;
		this.fixVersion = fixVersion;
	}

	// Accessing ==============================================================

	public BugtrackerConnection getConnection() {
		return connection;
	}

	public String getIssueKey() {
		return issueKey;
	}

	public JiraVersion getFixVersion() {
		return fixVersion;
	}
}