package com.syntevo.plugin.jira.transport;

import java.io.*;
import java.net.*;
import javax.net.ssl.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.common.bugtracker.transport.*;

/**
 * @author syntevo GmbH
 */
class JiraClient extends BugtrackerClient {

	// Setup ==================================================================

	public JiraClient(@NotNull BugtrackerConnection connection) {
		super(connection);
	}

	// Utils ==================================================================

	@Override
	public void configureConnection(@NotNull URLConnection connection) throws IOException {
		if (!(connection instanceof HttpsURLConnection)) {
			return;
		}

		final SSLContext context = createSSLContext(getBugtrackerConnection());
		((HttpsURLConnection)connection).setHostnameVerifier(new BugtrackerHttpsHostnameVerifier());
		((HttpsURLConnection)connection).setSSLSocketFactory(context.getSocketFactory());
	}
}