package com.syntevo.plugin.jira.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class JiraIssue {

	// Constants ==============================================================

	public static final String FIELD_ID = "id";
	public static final String FIELD_KEY = "key";
	public static final String FIELD_SUMMARY = "summary";
	public static final String FIELD_ASSIGNEE = "assignee";
	public static final String FIELD_TYPE = "type";
	public static final String FIELD_STATUS = "status";
	public static final String FIELD_RESOLUTION = "resolution";
	public static final String FIELD_FIX_VERSIONS = "fixVersions";

	// Fields =================================================================

	private String id;
	private String key;
	private String summary;
	private String assignee;
	private JiraIssueType type;
	private JiraIssueStatus status;
	private JiraIssueResolution resolution;
	private List<JiraVersion> fixVersions;

	// Setup ==================================================================

	public JiraIssue() {
	}

	// Accessing ==============================================================

	public String getKey() {
		return key;
	}

	public String getId() {
		return id;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public String getAssignee() {
		return assignee;
	}

	public void setAssignee(String assignee) {
		this.assignee = assignee;
	}

	public List<JiraVersion> getFixVersions() {
		return fixVersions != null ? Collections.unmodifiableList(fixVersions) : null;
	}

	public void setFixVersions(List<JiraVersion> fixVersions) {
		this.fixVersions = fixVersions != null ? new ArrayList<>(fixVersions) : null;
	}

	public JiraIssueType getType() {
		return type;
	}

	public void setType(JiraIssueType type) {
		this.type = type;
	}

	public JiraIssueStatus getStatus() {
		return status;
	}

	public void setStatus(JiraIssueStatus status) {
		this.status = status;
	}

	public JiraIssueResolution getResolution() {
		return resolution;
	}

	public void setResolution(JiraIssueResolution resolution) {
		this.resolution = resolution;
	}

	public void setKey(String id, String key) {
		this.id = id;
		this.key = key;
	}
}