package com.syntevo.plugin.mergeinfocolumn;

/**
 * @author syntevo GmbH
 */
final class MergeInfoType {

	// Constants ==============================================================

	public static final MergeInfoType NONE = new MergeInfoType("None", 0);
	public static final MergeInfoType EMPTY = new MergeInfoType("Empty", 1);
	public static final MergeInfoType PRESENT = new MergeInfoType("Present", 2);

	// Static =================================================================

	public static MergeInfoType internalToType(Object value) {
		if (value instanceof MergeInfoType) {
			return ((MergeInfoType)value);
		}

		return NONE;
	}

	public static Object stringToInternal(String propertyValue) {
		return propertyValue != null
				? (propertyValue.length() > 0 ? PRESENT : EMPTY)
				: null;
	}

	// Fields =================================================================

	private final String name;
	private final int value;

	// Setup ==================================================================

	private MergeInfoType(String name, int value) {
		this.name = name;
		this.value = value;
	}

	// Accessing ==============================================================

	public String getName() {
		return name;
	}

	public int getValue() {
		return value;
	}
}