package com.syntevo.plugin.precommithook;

import java.io.*;

import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;

/**
 * @author syntevo GmbH
 */
final class PreCommitHookCommitWorkflow extends FilterCommitWorkflow {

	// Fields =================================================================

	private final File preCommitHook;

	// Setup ==================================================================

	public PreCommitHookCommitWorkflow(ICommitWorkflow baseWorkflow, File preCommitHook) {
		super(baseWorkflow);

		this.preCommitHook = preCommitHook;
	}

	// Implemented ============================================================

	@Override
	public ICommitPreCommandPhase getPreCommandPhase() {
		final ICommitPreCommandPhase wrappedPhase = super.getPreCommandPhase();
		if (!preCommitHook.isFile()) {
			return wrappedPhase;
		}

		return new PreCommitHookCommitPhase(wrappedPhase, preCommitHook);
	}
}
