package com.syntevo.plugin.precommithook;

import java.io.*;

import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;

/**
 * @author syntevo GmbH
 */
final class PreCommitHookCommitWorkflowFactory implements ICommitWorkflowFactory {

	// Fields =================================================================

	private final File preCommitHook;

	// Setup ==================================================================

	public PreCommitHookCommitWorkflowFactory(File preCommitHook) {
		this.preCommitHook = preCommitHook;
	}

	// Implemented ============================================================

	@Override
	public ICommitWorkflow createWorkflow(ICommitWorkflow baseWorkflow, CommitWorkflowServices services) {
		return new PreCommitHookCommitWorkflow(baseWorkflow, preCommitHook);
	}
}
