package com.syntevo.plugin.precommithook;

import java.io.*;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.*;
import com.syntevo.openapi.deprecated.smartsvn.*;

/**
 * @author syntevo GmbH
 */
public final class PreCommitHookPlugin implements IActivator {

	// Constants ==============================================================

	public static final String PLUGIN_ID = "com.syntevo.commitTemplate";
	private static final String PRE_COMMIT_HOOK_NAME = "pre-commit";

	// Implemented ============================================================

	@Override
	public void initialize(@NotNull SmartSvnServices services) {
		final String fileName = System.getProperty("os.name").toLowerCase().contains("windows") ? PRE_COMMIT_HOOK_NAME + ".bat" : PRE_COMMIT_HOOK_NAME;
		File preCommitHook = services.getSettingsServices().getSettingsFile(fileName);
		if (!preCommitHook.exists()) {
			final File globalPreCommitHook = services.getSettingsServices().getDefaultSettingsFile(fileName);
			if (globalPreCommitHook.exists()) {
				preCommitHook = globalPreCommitHook;
			}
		}

		services.addCommitWorkflowFactory(new PreCommitHookCommitWorkflowFactory(preCommitHook));
	}
}
