package com.syntevo.plugin.removeemptydirectories;

import com.syntevo.openapi.deprecated.log.*;
import com.syntevo.openapi.deprecated.smartsvn.action.*;
import com.syntevo.openapi.deprecated.smartsvn.gui.menu.*;

/**
 * @author syntevo GmbH
 */
final class REDActionProvider implements IActionProvider {

	// Constants ==============================================================

	private static final Logger LOG = LoggerFactory.createLogger(REDActionProvider.class.getName());

	// Setup ==================================================================

	public REDActionProvider() {
	}

	// Implemented ============================================================

	@Override
	public void modifyMenuBar(MenuContainer menuContainer) {
		final boolean inserted = MenuUtils.insertActionAfter(ProjectActionIds.QUERY_EXPORT_BACKUP, REDFileDirectoryAction.ID, 0, "Remove Empty Directories...", "Schedule all empty directories for removal.", false, true, menuContainer);
		if (!inserted) {
			LOG.error("menu item not found");
		}
	}

	@Override
	public void createActions(ActionRegisterService service) {
		service.registerAction(REDFileDirectoryAction.ID, new REDFileDirectoryAction());
	}
}
