package com.syntevo.plugin.tagmultiple;

import java.util.List;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.gui.dialog.*;

/**
 * @author syntevo GmbH
 */
final class TagMultipleProjectRootsDialog extends AbstractOkCancelDialog {

	// Fields =================================================================

	private final List<String> previousTags;
	private final String initialCommitMessage;
	private final GuiSpacings spacings;

	private Combo tagNameComboBox;
	private Button fixExternalsCheckBox;
	private Text commitMessageText;
	private String tagName;
	private boolean fixExternals;
	private String commitMessage;

	// Setup ==================================================================

	public TagMultipleProjectRootsDialog(List<String> previousTags, boolean fixExternals, String initialCommitMessage, GuiSpacings spacings) {
		this.previousTags = previousTags;
		this.fixExternals = fixExternals;
		this.initialCommitMessage = initialCommitMessage;
		this.spacings = spacings;

		getOkAction().setName("Add Tag");
	}

	// Implemented ============================================================

	@Override
	public String getTitle() {
		return "Tag Multiple";
	}

	@Override
	public Control createComponent(Composite parent) {
		final Composite panel = new Composite(parent, SWT.NONE);

		final GridLayout layout = new GridLayout(2, false);
		layout.horizontalSpacing = spacings.getXRelated();
		layout.verticalSpacing = spacings.getYUnrelated();
		panel.setLayout(layout);

		final Label tagNameLabel = new Label(panel, SWT.NONE);
		tagNameLabel.setText("&Tag Name:");
		tagNameLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));

		tagNameComboBox = new Combo(panel, SWT.BORDER);
		tagNameComboBox.setItems(previousTags.toArray(new String[previousTags.size()]));
		tagNameComboBox.select(0);
		tagNameComboBox.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		selectTextIfTabbingToComponent(tagNameComboBox);

		final Label commitMessageLabel = new Label(panel, SWT.NONE);
		commitMessageLabel.setText("Commit &Message:");
		commitMessageLabel.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, false, 2, 1));

		commitMessageText = new Text(panel, SWT.BORDER | SWT.MULTI);
		if (initialCommitMessage != null) {
			commitMessageText.setText(initialCommitMessage);
		}
		selectTextIfTabbingToComponent(commitMessageText);
		final GridData data = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		data.minimumWidth = 300;
		data.minimumHeight = 150;
		commitMessageText.setLayoutData(data);

		fixExternalsCheckBox = new Button(panel, SWT.CHECK);
		fixExternalsCheckBox.setText("&Fix external revisions");
		fixExternalsCheckBox.setSelection(fixExternals);
		fixExternalsCheckBox.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, false, 2, 1));
		return panel;
	}

	@Override
	protected void ok() throws DialogValidationFailedException {
		final String text = tagNameComboBox.getText();
		tagName = text != null && text.trim().length() == 0 ? null : text;
		if (tagName == null) {
			throw new DialogValidationFailedException(tagNameComboBox, "Please enter a tag name.", "Don't use slashes!");
		}

		fixExternals = fixExternalsCheckBox.getSelection();
		commitMessage = commitMessageText.getText();
	}

	// Accessing ==============================================================

	@Nullable
	public String getTagName() {
		return tagName;
	}

	public boolean isFixExternals() {
		return fixExternals;
	}

	public String getCommitMessage() {
		return commitMessage;
	}

	// Utils ==================================================================

	private static void selectTextIfTabbingToComponent(final Control control) {
		if (!System.getProperty("os.name").contains("Windows")) {
			return;
		}

		selectAll(control);
		control.addListener(SWT.FocusOut, new Listener() {
			@Override
			public void handleEvent(Event event) {
				selectAll(control);
			}
		});
	}

	private static void selectAll(Control control) {
		if (control instanceof Text) {
			final Text text = (Text)control;
			text.selectAll();
		}
		else if (control instanceof Combo) {
			final Combo combo = (Combo)control;
			combo.setSelection(new Point(0, combo.getText().length()));
		}
	}
}
