package com.syntevo.plugin.trac;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.*;
import com.syntevo.openapi.deprecated.log.*;
import com.syntevo.openapi.deprecated.smartsvn.*;
import com.syntevo.plugin.trac.commit.messagesource.*;
import com.syntevo.plugin.trac.commit.workflow.*;

/**
 * @author syntevo GmbH
 */
public class TracPlugin implements IActivator {

	// Constants ==============================================================

	public static final String PLUGIN_ID = "com.syntevo.trac";
	public static final Logger LOGGER = LoggerFactory.createLogger(PLUGIN_ID);

	// Implemented ============================================================

	@Override
	public void initialize(@NotNull SmartSvnServices services) {
		services.addCommitMessageSourceFactory(new TracCommitMessageSourceFactory(services.getSettingsServices(), services.getGuiSpacings()));
		services.addCommitWorkflowFactory(new TracCommitWorkflowFactory(services.getSettingsServices(), services.getGuiSpacings()));
	}
}
