package com.syntevo.plugin.trac.commit.messagesource;

import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.trac.transport.*;

/**
 * @author syntevo GmbH
 */
final class TracIssueList {

	// Fields =================================================================


	private final Set<TracIssue> issues;

	// Setup ==================================================================

	public TracIssueList() {
		this.issues = new HashSet<>();
	}

	// Accessing ==============================================================

	public synchronized void addIssues(@NotNull List<TracIssue> issuesToAdd) {
		issues.addAll(issuesToAdd);
	}

	@NotNull
	public synchronized List<TracIssue> getIssuesInOrder(@NotNull List<TracIssueVersion> unreleasedVersions, @NotNull List<TracIssueMilestone> incompleteMilestones) {
		final List<TracIssue> issuesInOrder = new ArrayList<>(issues);
		Collections.sort(issuesInOrder, new TracIssueByRelevanceComparator(unreleasedVersions, incompleteMilestones));

		return issuesInOrder;
	}

	public synchronized void clear() {
		issues.clear();
	}
}