package com.syntevo.plugin.trac.commit.messagesource;

import java.io.*;
import java.util.*;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.trac.transport.*;

/**
 * @author syntevo GmbH
 */
final class TracIssueLoaderTableUpdater {

	// Fields =================================================================

	private final TracJsonRpcClient client;
	private final TracIssueList issueList;
	private final TracIssueTable table;

	private boolean aborted;

	// Setup ==================================================================

	public TracIssueLoaderTableUpdater(@NotNull TracJsonRpcClient client, @NotNull TracIssueList issueList, @NotNull TracIssueTable table) {
		this.client = client;
		this.issueList = issueList;
		this.table = table;
	}

	// Accessing ==============================================================

	public void load(@Nullable String assignee, @NotNull List<TracIssueStatus> states, @NotNull List<TracIssueVersion> fixVersions, @NotNull List<TracIssueMilestone> fixMilestones)
			throws IOException, JsonRpcException {
		boolean start = true;

		for (; !aborted; ) {
			final List<TracIssue> fetchedIssues;

			if (start) {
				start = false;
				fetchedIssues = client.getFirstIssues(assignee, states, fixVersions, fixMilestones, 100);
			}
			else {
				fetchedIssues = client.getNextIssues();
			}

			issueList.addIssues(fetchedIssues);
			table.setIssues(issueList.getIssuesInOrder(fixVersions, fixMilestones));

			if (fetchedIssues.isEmpty()) {
				return;
			}
		}
	}

	public void abort() {
		this.aborted = true;
	}
}