package com.syntevo.plugin.trac.commit.workflow;

import org.jetbrains.annotations.*;

import com.syntevo.openapi.deprecated.gui.*;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.*;
import com.syntevo.openapi.deprecated.smartsvn.settings.*;

/**
 * @author syntevo GmbH
 */
public final class TracCommitWorkflowFactory implements ICommitWorkflowFactory {

	// Fields =================================================================

	private final SettingsServices settingsServices;
	private final GuiSpacings spacings;

	// Setup ==================================================================

	public TracCommitWorkflowFactory(@NotNull SettingsServices settingsServices, @NotNull GuiSpacings spacings) {
		this.settingsServices = settingsServices;
		this.spacings = spacings;
	}

	// Implemented ============================================================

	@Override
	@NotNull
	public ICommitWorkflow createWorkflow(@NotNull ICommitWorkflow baseWorkflow, @NotNull CommitWorkflowServices services) {
		return new TracCommitWorkflow(baseWorkflow, services, settingsServices, spacings);
	}
}