package com.syntevo.plugin.trac.commit.workflow;

import org.jetbrains.annotations.*;

import com.syntevo.plugin.common.bugtracker.transport.*;

/**
 * @author syntevo GmbH
 */
class TracResolvePacket {

	// Fields =================================================================

	private final BugtrackerConnection connection;
	private final Integer issueId;
	private final String fixVersion;
	private final String fixMilestone;

	// Setup ==================================================================

	public TracResolvePacket(@NotNull BugtrackerConnection connection, @NotNull Integer issueId, @Nullable String fixVersion, @Nullable String fixMilestone) {
		this.connection = connection;
		this.issueId = issueId;
		this.fixVersion = fixVersion;
		this.fixMilestone = fixMilestone;
	}

	// Accessing ==============================================================

	@NotNull
	public BugtrackerConnection getConnection() {
		return connection;
	}

	@NotNull
	public Integer getIssueId() {
		return issueId;
	}

	@Nullable
	public String getFixVersion() {
		return fixVersion;
	}

	@Nullable
	public String getFixMilestone() {
		return fixMilestone;
	}
}