package com.syntevo.plugin.trac.transport;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public final class TracIssueResolution {

	// Constants ==============================================================
	// As received from XMLRPCPlugin interface ticket.resolution.getAll()

	public static final TracIssueResolution FIXED = new TracIssueResolution(System.getProperty("smartsvn.plugin.trac.resolved-constant", "fixed"));
	public static final TracIssueResolution INVALID = new TracIssueResolution("invalid");
	public static final TracIssueResolution WONT_FIX = new TracIssueResolution("wontfix");
	public static final TracIssueResolution DUPLICATE = new TracIssueResolution("duplicate");
	public static final TracIssueResolution WORKS_FOR_ME = new TracIssueResolution("worksforme");
	public static final TracIssueResolution UNKNOWN = new TracIssueResolution("unknown");
	public static final List<TracIssueResolution> ALL = Collections.unmodifiableList(Arrays.asList(FIXED, INVALID, WONT_FIX, DUPLICATE, WORKS_FOR_ME, UNKNOWN));

	// Static =================================================================

	public static TracIssueResolution parseFromId(String tracId) {
		for (TracIssueResolution resolution : ALL) {
			if (resolution.tracId != null && resolution.tracId.equals(tracId)) {
				return resolution;
			}
		}

		return UNKNOWN;
	}

	// Fields =================================================================

	private final String tracId;

	// Setup ==================================================================

	public TracIssueResolution(@NotNull String tracId) {
		this.tracId = tracId;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return tracId;
	}
}