package com.syntevo.plugin.trac.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class TracIssueStatus {

	// Constants ==============================================================

	// As received from XMLRPCPlugin interface ticket.status.getAll()
	public static final TracIssueStatus ACCEPTED = new TracIssueStatus("accepted", "Accepted", 1);
	public static final TracIssueStatus ASSIGNED = new TracIssueStatus("assigned", "Assigned", 2);
	public static final TracIssueStatus REOPENED = new TracIssueStatus("reopened", "Reopened", 3);
	public static final TracIssueStatus NEW = new TracIssueStatus("new", "New", 4);
	public static final TracIssueStatus CLOSED = new TracIssueStatus("closed", "Closed", 5);
	public static final TracIssueStatus UNKNOWN = new TracIssueStatus("unknown", "???", 6);
	public static final List<TracIssueStatus> ALL = Collections.unmodifiableList(Arrays.asList(ACCEPTED, ASSIGNED, CLOSED, NEW, REOPENED, UNKNOWN));

	// Static =================================================================

	public static TracIssueStatus parseFromId(String tracId) {
		for (TracIssueStatus status : ALL) {
			if (status.tracId != null && status.tracId.equals(tracId)) {
				return status;
			}
		}

		return UNKNOWN;
	}

	// Fields =================================================================

	private final String tracId;
	private final String name;
	private final int priority;

	// Setup ==================================================================

	public TracIssueStatus(String tracId, String name, int priority) {
		this.tracId = tracId;
		this.name = name;
		this.priority = priority;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return tracId;
	}

	// Accessing ==============================================================

	public String getName() {
		return name;
	}

	public int getPriority() {
		return priority;
	}
}