package com.syntevo.plugin.trac.transport;

import java.util.*;

/**
 * @author syntevo GmbH
 */
public final class TracIssueType {

	// Constants ==============================================================
	// As received from XMLRPCPlugin interface ticket.type.getAll()
	public static final TracIssueType DEFECT = new TracIssueType("defect");
	public static final TracIssueType ENHANCEMENT = new TracIssueType("enhancement");
	public static final TracIssueType TASK = new TracIssueType("task");
	public static final TracIssueType UNKNOWN = new TracIssueType("unknown");
	public static final List<TracIssueType> ALL = Collections.unmodifiableList(Arrays.asList(DEFECT, ENHANCEMENT, TASK, UNKNOWN));

	// Static =================================================================

	public static TracIssueType parseFromId(String tracId) {
		for (TracIssueType type : ALL) {
			if (type.tracId != null && type.tracId.equals(tracId)) {
				return type;
			}
		}

		return UNKNOWN;
	}

	// Fields =================================================================

	private final String tracId;

	// Setup ==================================================================

	public TracIssueType(String tracId) {
		this.tracId = tracId;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return tracId;
	}
}