package com.syntevo.plugin.trac.transport;

import java.util.*;

import org.jetbrains.annotations.*;

/**
 * @author syntevo GmbH
 */
public class TracIssueVersion {

	// Fields =================================================================

	private final String name;
	private final String description;
	private final Date releasedDate;

	// Setup ==================================================================

	public TracIssueVersion(@NotNull String name, @Nullable String description, @Nullable Date releasedDate) {
		this.name = name;
		this.description = description;
		this.releasedDate = releasedDate;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return name;
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || obj.getClass() != getClass()) {
			return false;
		}

		final TracIssueVersion version = (TracIssueVersion)obj;
		return name.equals(version.name);
	}

	// Accessing ==============================================================

	@NotNull
	public String getName() {
		return name;
	}

	@Nullable
	public String getDescription() {
		return description;
	}

	@Nullable
	public Date getReleasedDate() {
		return releasedDate;
	}
}